import 'package:dartz/dartz.dart';
import 'package:razinsoft_rider/data/models/common_response.dart';
import 'package:razinsoft_rider/data/repositories/interfaces/rating_repo_interface.dart';
import 'package:razinsoft_rider/domain/interfaces/rating_service_interface.dart';

import '../../core/errors/failure.dart';
import 'base_repository.dart';

class RatingRepoImpl extends BaseRepository implements IRatingRepo {
  final IRatingService ratingService;

  RatingRepoImpl({required this.ratingService});

  @override
  Future<Either<Failure, CommonResponse>> rating({required double rating, String? comment, required int? orderId}) async => await safeApiCall(()async{
      final response = await ratingService.rating(rating: rating, comment: comment, orderId: orderId);
      try {
        return CommonResponse.fromMap(response.data);
      } catch (e) {
        throw Exception('Parsing error');
      }

    });}